/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { Translator } from "./i18n.js";

/**
 * This was taken from https://raw.githubusercontent.com/umpirsky/language-list/refs/heads/master/data/ak/language.txt
 *
 * FIXME: Check with ISO standard
 */
export const enum LangCode {
  aa,
  ab,
  ace,
  ach,
  ada,
  ady,
  ae,
  aeb,
  af,
  afh,
  agq,
  ain,
  ak,
  akk,
  akz,
  ale,
  aln,
  alt,
  am,
  an,
  ang,
  anp,
  ar_001,
  ar,
  arc,
  arn,
  aro,
  arp,
  arq,
  arw,
  ary,
  arz,
  asa,
  as,
  ase,
  ast,
  av,
  avk,
  awa,
  ay,
  az,
  azb,
  ba,
  bal,
  ban,
  bar,
  bas,
  bax,
  bbc,
  bbj,
  be,
  bej,
  bem,
  bew,
  bez,
  bfd,
  bfq,
  bg,
  bho,
  bi,
  bik,
  bin,
  bjn,
  bkm,
  bla,
  bm,
  bn,
  bo,
  bpy,
  bqi,
  bra,
  br,
  brh,
  brx,
  bs,
  bss,
  bua,
  bug,
  bum,
  byn,
  byv,
  ca,
  cad,
  car,
  cay,
  cch,
  ceb,
  ce,
  cgg,
  chb,
  ch,
  chg,
  chk,
  chm,
  chn,
  cho,
  chp,
  chr,
  chy,
  ckb,
  co,
  cop,
  cps,
  cr,
  crh,
  csb,
  cs,
  cu,
  cv,
  cy,
  da,
  dak,
  dar,
  dav,
  de_AT,
  de_CH,
  de,
  del,
  den,
  dgr,
  din,
  dje,
  doi,
  dsb,
  dtp,
  dua,
  dum,
  dv,
  dyo,
  dyu,
  dz,
  dzg,
  ebu,
  ee,
  efi,
  egl,
  egy,
  eka,
  el,
  elx,
  en_AU,
  en,
  en_CA,
  en_GB,
  enm,
  en_US,
  eo,
  es_419,
  es_ES,
  es_MX,
  es,
  esu,
  et,
  eu,
  ewo,
  ext,
  fan,
  fa,
  fat,
  ff,
  fi,
  fil,
  fit,
  fj,
  fo,
  fon,
  fr_CA,
  frc,
  fr_CH,
  fr,
  frm,
  fro,
  frp,
  frr,
  frs,
  fur,
  fy,
  gaa,
  gag,
  ga,
  gan,
  gay,
  gba,
  gbz,
  gd,
  gez,
  gil,
  gl,
  glk,
  gmh,
  gn,
  goh,
  gom,
  gon,
  gor,
  got,
  grb,
  grc,
  gsw,
  guc,
  gu,
  gur,
  guz,
  gv,
  gwi,
  ha,
  hai,
  hak,
  haw,
  he,
  hif,
  hi,
  hil,
  hit,
  hmn,
  ho,
  hr,
  hsb,
  hsn,
  ht,
  hu,
  hup,
  hy,
  hz,
  ia,
  iba,
  ibb,
  id,
  ie,
  ig,
  ii,
  ik,
  ilo,
  inh,
  io,
  is,
  it,
  iu,
  izh,
  ja,
  jam,
  jbo,
  jgo,
  jmc,
  jpr,
  jrb,
  jut,
  jv,
  kaa,
  kab,
  kac,
  ka,
  kaj,
  kam,
  kaw,
  kbd,
  kbl,
  kcg,
  kde,
  kea,
  ken,
  kfo,
  kg,
  kgp,
  kha,
  kho,
  khq,
  khw,
  ki,
  kiu,
  kj,
  kkj,
  kk,
  kl,
  kln,
  kmb,
  km,
  kn,
  koi,
  kok,
  ko,
  kos,
  kpe,
  krc,
  kri,
  krj,
  kr,
  krl,
  kru,
  ksb,
  ksf,
  ksh,
  ks,
  ku,
  kum,
  kut,
  kv,
  kw,
  ky,
  lad,
  lag,
  lah,
  la,
  lam,
  lb,
  lez,
  lfn,
  lg,
  lij,
  li,
  liv,
  lkt,
  lmo,
  ln,
  lo,
  lol,
  loz,
  ltg,
  lt,
  lua,
  lui,
  lu,
  lun,
  luo,
  lus,
  luy,
  lv,
  lzh,
  lzz,
  mad,
  maf,
  mag,
  mai,
  mak,
  man,
  mas,
  mde,
  mdf,
  mdr,
  men,
  mer,
  mfe,
  mga,
  mgh,
  mg,
  mgo,
  mh,
  mic,
  mi,
  min,
  mk,
  ml,
  mnc,
  mni,
  mn,
  moh,
  mos,
  mrj,
  mr,
  ms,
  mt,
  mua,
  mul,
  mus,
  mwl,
  mwr,
  mwv,
  my,
  mye,
  myv,
  mzn,
  na,
  nan,
  nap,
  naq,
  nb,
  nd,
  nds,
  ne,
  new,
  ng,
  nia,
  niu,
  njo,
  nl_BE,
  nl,
  nmg,
  nnh,
  nn,
  nog,
  non,
  no,
  nov,
  nqo,
  nr,
  nso,
  nus,
  nv,
  nwc,
  nym,
  nyn,
  ny,
  nyo,
  nzi,
  oc,
  oj,
  om,
  or,
  osa,
  os,
  ota,
  pag,
  pal,
  pam,
  pap,
  pa,
  pau,
  pcd,
  pdc,
  pdt,
  peo,
  pfl,
  phn,
  pi,
  pl,
  pms,
  pnt,
  pon,
  prg,
  pro,
  ps,
  pt_BR,
  pt,
  pt_PT,
  quc,
  qug,
  qu,
  raj,
  rap,
  rar,
  rgn,
  rif,
  rm,
  rn,
  rof,
  ro_MD,
  rom,
  root,
  ro,
  rtm,
  rue,
  rug,
  rup,
  ru,
  rwk,
  rw,
  sad,
  sah,
  sam,
  saq,
  sa,
  sas,
  sat,
  saz,
  sba,
  sbp,
  scn,
  sco,
  sc,
  sdc,
  sd,
  see,
  seh,
  sei,
  sel,
  se,
  ses,
  sga,
  sg,
  sgs,
  shi,
  shn,
  sh,
  shu,
  sid,
  si,
  sk,
  sli,
  sl,
  sly,
  sma,
  smj,
  smn,
  sm,
  sms,
  snk,
  sn,
  sog,
  so,
  sq,
  srn,
  srr,
  sr,
  ss,
  ssy,
  stq,
  st,
  suk,
  sus,
  su,
  sux,
  sv,
  swb,
  swc,
  sw,
  syc,
  syr,
  szl,
  ta,
  tcy,
  tem,
  teo,
  ter,
  te,
  tet,
  tg,
  th,
  tig,
  ti,
  tiv,
  tkl,
  tkr,
  tk,
  tlh,
  tli,
  tl,
  tly,
  tmh,
  tn,
  tog,
  to,
  tpi,
  tr,
  tru,
  trv,
  tsd,
  tsi,
  ts,
  tt,
  ttt,
  tum,
  tvl,
  twq,
  tw,
  ty,
  tyv,
  tzm,
  udm,
  uga,
  ug,
  uk,
  umb,
  und,
  ur,
  uz,
  vai,
  vec,
  vep,
  ve,
  vi,
  vls,
  vmf,
  vot,
  vo,
  vro,
  vun,
  wae,
  wal,
  war,
  was,
  wa,
  wbp,
  wo,
  wuu,
  xal,
  xh,
  xmf,
  xog,
  yao,
  yap,
  yav,
  ybb,
  yi,
  yo,
  yrl,
  yue,
  zap,
  za,
  zbl,
  zea,
  zen,
  zgh,
  zh_Hans,
  zh_Hant,
  zh,
  zun,
  zu,
  zxx,
  zza,
}

export const langNamesByCode: { [c in LangCode]: Translator } = {
  [LangCode.aa]: (i18n) => i18n.str`Afar`,
  [LangCode.ab]: (i18n) => i18n.str`Abkhazian`,
  [LangCode.ace]: (i18n) => i18n.str`Achinese`,
  [LangCode.ach]: (i18n) => i18n.str`Acoli`,
  [LangCode.ada]: (i18n) => i18n.str`Adangme`,
  [LangCode.ady]: (i18n) => i18n.str`Adyghe`,
  [LangCode.ae]: (i18n) => i18n.str`Avestan`,
  [LangCode.aeb]: (i18n) => i18n.str`Tunisian Arabic`,
  [LangCode.af]: (i18n) => i18n.str`Afrikaans`,
  [LangCode.afh]: (i18n) => i18n.str`Afrihili`,
  [LangCode.agq]: (i18n) => i18n.str`Aghem`,
  [LangCode.ain]: (i18n) => i18n.str`Ainu`,
  [LangCode.ak]: (i18n) => i18n.str`Akan`,
  [LangCode.akk]: (i18n) => i18n.str`Akkadian`,
  [LangCode.akz]: (i18n) => i18n.str`Alabama`,
  [LangCode.ale]: (i18n) => i18n.str`Aleut`,
  [LangCode.aln]: (i18n) => i18n.str`Gheg Albanian`,
  [LangCode.alt]: (i18n) => i18n.str`Southern Altai`,
  [LangCode.am]: (i18n) => i18n.str`Amarik`,
  [LangCode.an]: (i18n) => i18n.str`Aragonese`,
  [LangCode.ang]: (i18n) => i18n.str`Old English`,
  [LangCode.anp]: (i18n) => i18n.str`Angika`,
  [LangCode.ar_001]: (i18n) => i18n.str`Modern Standard Arabic`,
  [LangCode.ar]: (i18n) => i18n.str`Arabik`,
  [LangCode.arc]: (i18n) => i18n.str`Aramaic`,
  [LangCode.arn]: (i18n) => i18n.str`Mapuche`,
  [LangCode.aro]: (i18n) => i18n.str`Araona`,
  [LangCode.arp]: (i18n) => i18n.str`Arapaho`,
  [LangCode.arq]: (i18n) => i18n.str`Algerian Arabic`,
  [LangCode.arw]: (i18n) => i18n.str`Arawak`,
  [LangCode.ary]: (i18n) => i18n.str`Moroccan Arabic`,
  [LangCode.arz]: (i18n) => i18n.str`Egyptian Arabic`,
  [LangCode.asa]: (i18n) => i18n.str`Asu`,
  [LangCode.as]: (i18n) => i18n.str`Assamese`,
  [LangCode.ase]: (i18n) => i18n.str`American Sign Language`,
  [LangCode.ast]: (i18n) => i18n.str`Asturian`,
  [LangCode.av]: (i18n) => i18n.str`Avaric`,
  [LangCode.avk]: (i18n) => i18n.str`Kotava`,
  [LangCode.awa]: (i18n) => i18n.str`Awadhi`,
  [LangCode.ay]: (i18n) => i18n.str`Aymara`,
  [LangCode.az]: (i18n) => i18n.str`Azerbaijani`,
  [LangCode.azb]: (i18n) => i18n.str`South Azerbaijani`,
  [LangCode.ba]: (i18n) => i18n.str`Bashkir`,
  [LangCode.bal]: (i18n) => i18n.str`Baluchi`,
  [LangCode.ban]: (i18n) => i18n.str`Balinese`,
  [LangCode.bar]: (i18n) => i18n.str`Bavarian`,
  [LangCode.bas]: (i18n) => i18n.str`Basaa`,
  [LangCode.bax]: (i18n) => i18n.str`Bamun`,
  [LangCode.bbc]: (i18n) => i18n.str`Batak Toba`,
  [LangCode.bbj]: (i18n) => i18n.str`Ghomala`,
  [LangCode.be]: (i18n) => i18n.str`Belarus kasa`,
  [LangCode.bej]: (i18n) => i18n.str`Beja`,
  [LangCode.bem]: (i18n) => i18n.str`Bemba`,
  [LangCode.bew]: (i18n) => i18n.str`Betawi`,
  [LangCode.bez]: (i18n) => i18n.str`Bena`,
  [LangCode.bfd]: (i18n) => i18n.str`Bafut`,
  [LangCode.bfq]: (i18n) => i18n.str`Badaga`,
  [LangCode.bg]: (i18n) => i18n.str`Bɔlgeria kasa`,
  [LangCode.bho]: (i18n) => i18n.str`Bhojpuri`,
  [LangCode.bi]: (i18n) => i18n.str`Bislama`,
  [LangCode.bik]: (i18n) => i18n.str`Bikol`,
  [LangCode.bin]: (i18n) => i18n.str`Bini`,
  [LangCode.bjn]: (i18n) => i18n.str`Banjar`,
  [LangCode.bkm]: (i18n) => i18n.str`Kom`,
  [LangCode.bla]: (i18n) => i18n.str`Siksika`,
  [LangCode.bm]: (i18n) => i18n.str`Bambara`,
  [LangCode.bn]: (i18n) => i18n.str`Bengali kasa`,
  [LangCode.bo]: (i18n) => i18n.str`Tibetan`,
  [LangCode.bpy]: (i18n) => i18n.str`Bishnupriya`,
  [LangCode.bqi]: (i18n) => i18n.str`Bakhtiari`,
  [LangCode.bra]: (i18n) => i18n.str`Braj`,
  [LangCode.br]: (i18n) => i18n.str`Breton`,
  [LangCode.brh]: (i18n) => i18n.str`Brahui`,
  [LangCode.brx]: (i18n) => i18n.str`Bodo`,
  [LangCode.bs]: (i18n) => i18n.str`Bosnian`,
  [LangCode.bss]: (i18n) => i18n.str`Akoose`,
  [LangCode.bua]: (i18n) => i18n.str`Buriat`,
  [LangCode.bug]: (i18n) => i18n.str`Buginese`,
  [LangCode.bum]: (i18n) => i18n.str`Bulu`,
  [LangCode.byn]: (i18n) => i18n.str`Blin`,
  [LangCode.byv]: (i18n) => i18n.str`Medumba`,
  [LangCode.ca]: (i18n) => i18n.str`Catalan`,
  [LangCode.cad]: (i18n) => i18n.str`Caddo`,
  [LangCode.car]: (i18n) => i18n.str`Carib`,
  [LangCode.cay]: (i18n) => i18n.str`Cayuga`,
  [LangCode.cch]: (i18n) => i18n.str`Atsam`,
  [LangCode.ceb]: (i18n) => i18n.str`Cebuano`,
  [LangCode.ce]: (i18n) => i18n.str`Chechen`,
  [LangCode.cgg]: (i18n) => i18n.str`Chiga`,
  [LangCode.chb]: (i18n) => i18n.str`Chibcha`,
  [LangCode.ch]: (i18n) => i18n.str`Chamorro`,
  [LangCode.chg]: (i18n) => i18n.str`Chagatai`,
  [LangCode.chk]: (i18n) => i18n.str`Chuukese`,
  [LangCode.chm]: (i18n) => i18n.str`Mari`,
  [LangCode.chn]: (i18n) => i18n.str`Chinook Jargon`,
  [LangCode.cho]: (i18n) => i18n.str`Choctaw`,
  [LangCode.chp]: (i18n) => i18n.str`Chipewyan`,
  [LangCode.chr]: (i18n) => i18n.str`Cherokee`,
  [LangCode.chy]: (i18n) => i18n.str`Cheyenne`,
  [LangCode.ckb]: (i18n) => i18n.str`Central Kurdish`,
  [LangCode.co]: (i18n) => i18n.str`Corsican`,
  [LangCode.cop]: (i18n) => i18n.str`Coptic`,
  [LangCode.cps]: (i18n) => i18n.str`Capiznon`,
  [LangCode.cr]: (i18n) => i18n.str`Cree`,
  [LangCode.crh]: (i18n) => i18n.str`Crimean Turkish`,
  [LangCode.csb]: (i18n) => i18n.str`Kashubian`,
  [LangCode.cs]: (i18n) => i18n.str`Kyɛk kasa`,
  [LangCode.cu]: (i18n) => i18n.str`Church Slavic`,
  [LangCode.cv]: (i18n) => i18n.str`Chuvash`,
  [LangCode.cy]: (i18n) => i18n.str`Welsh`,
  [LangCode.da]: (i18n) => i18n.str`Danish`,
  [LangCode.dak]: (i18n) => i18n.str`Dakota`,
  [LangCode.dar]: (i18n) => i18n.str`Dargwa`,
  [LangCode.dav]: (i18n) => i18n.str`Taita`,
  [LangCode.de_AT]: (i18n) => i18n.str`Austrian German`,
  [LangCode.de_CH]: (i18n) => i18n.str`Swiss High German`,
  [LangCode.de]: (i18n) => i18n.str`Gyaaman`,
  [LangCode.del]: (i18n) => i18n.str`Delaware`,
  [LangCode.den]: (i18n) => i18n.str`Slave`,
  [LangCode.dgr]: (i18n) => i18n.str`Dogrib`,
  [LangCode.din]: (i18n) => i18n.str`Dinka`,
  [LangCode.dje]: (i18n) => i18n.str`Zarma`,
  [LangCode.doi]: (i18n) => i18n.str`Dogri`,
  [LangCode.dsb]: (i18n) => i18n.str`Lower Sorbian`,
  [LangCode.dtp]: (i18n) => i18n.str`Central Dusun`,
  [LangCode.dua]: (i18n) => i18n.str`Duala`,
  [LangCode.dum]: (i18n) => i18n.str`Middle Dutch`,
  [LangCode.dv]: (i18n) => i18n.str`Divehi`,
  [LangCode.dyo]: (i18n) => i18n.str`Jola-Fonyi`,
  [LangCode.dyu]: (i18n) => i18n.str`Dyula`,
  [LangCode.dz]: (i18n) => i18n.str`Dzongkha`,
  [LangCode.dzg]: (i18n) => i18n.str`Dazaga`,
  [LangCode.ebu]: (i18n) => i18n.str`Embu`,
  [LangCode.ee]: (i18n) => i18n.str`Ewe`,
  [LangCode.efi]: (i18n) => i18n.str`Efik`,
  [LangCode.egl]: (i18n) => i18n.str`Emilian`,
  [LangCode.egy]: (i18n) => i18n.str`Ancient Egyptian`,
  [LangCode.eka]: (i18n) => i18n.str`Ekajuk`,
  [LangCode.el]: (i18n) => i18n.str`Greek kasa`,
  [LangCode.elx]: (i18n) => i18n.str`Elamite`,
  [LangCode.en_AU]: (i18n) => i18n.str`Australian English`,
  [LangCode.en]: (i18n) => i18n.str`Borɔfo`,
  [LangCode.en_CA]: (i18n) => i18n.str`Canadian English`,
  [LangCode.en_GB]: (i18n) => i18n.str`British English`,
  [LangCode.enm]: (i18n) => i18n.str`Middle English`,
  [LangCode.en_US]: (i18n) => i18n.str`American English`,
  [LangCode.eo]: (i18n) => i18n.str`Esperanto`,
  [LangCode.es_419]: (i18n) => i18n.str`Latin American Spanish`,
  [LangCode.es_ES]: (i18n) => i18n.str`European Spanish`,
  [LangCode.es_MX]: (i18n) => i18n.str`Mexican Spanish`,
  [LangCode.es]: (i18n) => i18n.str`Spain kasa`,
  [LangCode.esu]: (i18n) => i18n.str`Central Yupik`,
  [LangCode.et]: (i18n) => i18n.str`Estonian`,
  [LangCode.eu]: (i18n) => i18n.str`Basque`,
  [LangCode.ewo]: (i18n) => i18n.str`Ewondo`,
  [LangCode.ext]: (i18n) => i18n.str`Extremaduran`,
  [LangCode.fan]: (i18n) => i18n.str`Fang`,
  [LangCode.fa]: (i18n) => i18n.str`Pɛɛhyia kasa`,
  [LangCode.fat]: (i18n) => i18n.str`Fanti`,
  [LangCode.ff]: (i18n) => i18n.str`Fulah`,
  [LangCode.fi]: (i18n) => i18n.str`Finnish`,
  [LangCode.fil]: (i18n) => i18n.str`Filipino`,
  [LangCode.fit]: (i18n) => i18n.str`Tornedalen Finnish`,
  [LangCode.fj]: (i18n) => i18n.str`Fijian`,
  [LangCode.fo]: (i18n) => i18n.str`Faroese`,
  [LangCode.fon]: (i18n) => i18n.str`Fon`,
  [LangCode.fr_CA]: (i18n) => i18n.str`Canadian French`,
  [LangCode.frc]: (i18n) => i18n.str`Cajun French`,
  [LangCode.fr_CH]: (i18n) => i18n.str`Swiss French`,
  [LangCode.fr]: (i18n) => i18n.str`Frɛnkye`,
  [LangCode.frm]: (i18n) => i18n.str`Middle French`,
  [LangCode.fro]: (i18n) => i18n.str`Old French`,
  [LangCode.frp]: (i18n) => i18n.str`Arpitan`,
  [LangCode.frr]: (i18n) => i18n.str`Northern Frisian`,
  [LangCode.frs]: (i18n) => i18n.str`Eastern Frisian`,
  [LangCode.fur]: (i18n) => i18n.str`Friulian`,
  [LangCode.fy]: (i18n) => i18n.str`Western Frisian`,
  [LangCode.gaa]: (i18n) => i18n.str`Ga`,
  [LangCode.gag]: (i18n) => i18n.str`Gagauz`,
  [LangCode.ga]: (i18n) => i18n.str`Irish`,
  [LangCode.gan]: (i18n) => i18n.str`Gan Chinese`,
  [LangCode.gay]: (i18n) => i18n.str`Gayo`,
  [LangCode.gba]: (i18n) => i18n.str`Gbaya`,
  [LangCode.gbz]: (i18n) => i18n.str`Zoroastrian Dari`,
  [LangCode.gd]: (i18n) => i18n.str`Scottish Gaelic`,
  [LangCode.gez]: (i18n) => i18n.str`Geez`,
  [LangCode.gil]: (i18n) => i18n.str`Gilbertese`,
  [LangCode.gl]: (i18n) => i18n.str`Galician`,
  [LangCode.glk]: (i18n) => i18n.str`Gilaki`,
  [LangCode.gmh]: (i18n) => i18n.str`Middle High German`,
  [LangCode.gn]: (i18n) => i18n.str`Guarani`,
  [LangCode.goh]: (i18n) => i18n.str`Old High German`,
  [LangCode.gom]: (i18n) => i18n.str`Goan Konkani`,
  [LangCode.gon]: (i18n) => i18n.str`Gondi`,
  [LangCode.gor]: (i18n) => i18n.str`Gorontalo`,
  [LangCode.got]: (i18n) => i18n.str`Gothic`,
  [LangCode.grb]: (i18n) => i18n.str`Grebo`,
  [LangCode.grc]: (i18n) => i18n.str`Ancient Greek`,
  [LangCode.gsw]: (i18n) => i18n.str`Swiss German`,
  [LangCode.guc]: (i18n) => i18n.str`Wayuu`,
  [LangCode.gu]: (i18n) => i18n.str`Gujarati`,
  [LangCode.gur]: (i18n) => i18n.str`Frafra`,
  [LangCode.guz]: (i18n) => i18n.str`Gusii`,
  [LangCode.gv]: (i18n) => i18n.str`Manx`,
  [LangCode.gwi]: (i18n) => i18n.str`Gwichʼin`,
  [LangCode.ha]: (i18n) => i18n.str`Hausa`,
  [LangCode.hai]: (i18n) => i18n.str`Haida`,
  [LangCode.hak]: (i18n) => i18n.str`Hakka Chinese`,
  [LangCode.haw]: (i18n) => i18n.str`Hawaiian`,
  [LangCode.he]: (i18n) => i18n.str`Hebrew`,
  [LangCode.hif]: (i18n) => i18n.str`Fiji Hindi`,
  [LangCode.hi]: (i18n) => i18n.str`Hindi`,
  [LangCode.hil]: (i18n) => i18n.str`Hiligaynon`,
  [LangCode.hit]: (i18n) => i18n.str`Hittite`,
  [LangCode.hmn]: (i18n) => i18n.str`Hmong`,
  [LangCode.ho]: (i18n) => i18n.str`Hiri Motu`,
  [LangCode.hr]: (i18n) => i18n.str`Croatian`,
  [LangCode.hsb]: (i18n) => i18n.str`Upper Sorbian`,
  [LangCode.hsn]: (i18n) => i18n.str`Xiang Chinese`,
  [LangCode.ht]: (i18n) => i18n.str`Haitian`,
  [LangCode.hu]: (i18n) => i18n.str`Hangri kasa`,
  [LangCode.hup]: (i18n) => i18n.str`Hupa`,
  [LangCode.hy]: (i18n) => i18n.str`Armenian`,
  [LangCode.hz]: (i18n) => i18n.str`Herero`,
  [LangCode.ia]: (i18n) => i18n.str`Interlingua`,
  [LangCode.iba]: (i18n) => i18n.str`Iban`,
  [LangCode.ibb]: (i18n) => i18n.str`Ibibio`,
  [LangCode.id]: (i18n) => i18n.str`Indonihyia kasa`,
  [LangCode.ie]: (i18n) => i18n.str`Interlingue`,
  [LangCode.ig]: (i18n) => i18n.str`Igbo`,
  [LangCode.ii]: (i18n) => i18n.str`Sichuan Yi`,
  [LangCode.ik]: (i18n) => i18n.str`Inupiaq`,
  [LangCode.ilo]: (i18n) => i18n.str`Iloko`,
  [LangCode.inh]: (i18n) => i18n.str`Ingush`,
  [LangCode.io]: (i18n) => i18n.str`Ido`,
  [LangCode.is]: (i18n) => i18n.str`Icelandic`,
  [LangCode.it]: (i18n) => i18n.str`Italy kasa`,
  [LangCode.iu]: (i18n) => i18n.str`Inuktitut`,
  [LangCode.izh]: (i18n) => i18n.str`Ingrian`,
  [LangCode.ja]: (i18n) => i18n.str`Gyapan kasa`,
  [LangCode.jam]: (i18n) => i18n.str`Jamaican Creole English`,
  [LangCode.jbo]: (i18n) => i18n.str`Lojban`,
  [LangCode.jgo]: (i18n) => i18n.str`Ngomba`,
  [LangCode.jmc]: (i18n) => i18n.str`Machame`,
  [LangCode.jpr]: (i18n) => i18n.str`Judeo-Persian`,
  [LangCode.jrb]: (i18n) => i18n.str`Judeo-Arabic`,
  [LangCode.jut]: (i18n) => i18n.str`Jutish`,
  [LangCode.jv]: (i18n) => i18n.str`Gyabanis kasa`,
  [LangCode.kaa]: (i18n) => i18n.str`Kara-Kalpak`,
  [LangCode.kab]: (i18n) => i18n.str`Kabyle`,
  [LangCode.kac]: (i18n) => i18n.str`Kachin`,
  [LangCode.ka]: (i18n) => i18n.str`Georgian`,
  [LangCode.kaj]: (i18n) => i18n.str`Jju`,
  [LangCode.kam]: (i18n) => i18n.str`Kamba`,
  [LangCode.kaw]: (i18n) => i18n.str`Kawi`,
  [LangCode.kbd]: (i18n) => i18n.str`Kabardian`,
  [LangCode.kbl]: (i18n) => i18n.str`Kanembu`,
  [LangCode.kcg]: (i18n) => i18n.str`Tyap`,
  [LangCode.kde]: (i18n) => i18n.str`Makonde`,
  [LangCode.kea]: (i18n) => i18n.str`Kabuverdianu`,
  [LangCode.ken]: (i18n) => i18n.str`Kenyang`,
  [LangCode.kfo]: (i18n) => i18n.str`Koro`,
  [LangCode.kg]: (i18n) => i18n.str`Kongo`,
  [LangCode.kgp]: (i18n) => i18n.str`Kaingang`,
  [LangCode.kha]: (i18n) => i18n.str`Khasi`,
  [LangCode.kho]: (i18n) => i18n.str`Khotanese`,
  [LangCode.khq]: (i18n) => i18n.str`Koyra Chiini`,
  [LangCode.khw]: (i18n) => i18n.str`Khowar`,
  [LangCode.ki]: (i18n) => i18n.str`Kikuyu`,
  [LangCode.kiu]: (i18n) => i18n.str`Kirmanjki`,
  [LangCode.kj]: (i18n) => i18n.str`Kuanyama`,
  [LangCode.kkj]: (i18n) => i18n.str`Kako`,
  [LangCode.kk]: (i18n) => i18n.str`Kazakh`,
  [LangCode.kl]: (i18n) => i18n.str`Kalaallisut`,
  [LangCode.kln]: (i18n) => i18n.str`Kalenjin`,
  [LangCode.kmb]: (i18n) => i18n.str`Kimbundu`,
  [LangCode.km]: (i18n) => i18n.str`Kambodia kasa`,
  [LangCode.kn]: (i18n) => i18n.str`Kannada`,
  [LangCode.koi]: (i18n) => i18n.str`Komi-Permyak`,
  [LangCode.kok]: (i18n) => i18n.str`Konkani`,
  [LangCode.ko]: (i18n) => i18n.str`Korea kasa`,
  [LangCode.kos]: (i18n) => i18n.str`Kosraean`,
  [LangCode.kpe]: (i18n) => i18n.str`Kpelle`,
  [LangCode.krc]: (i18n) => i18n.str`Karachay-Balkar`,
  [LangCode.kri]: (i18n) => i18n.str`Krio`,
  [LangCode.krj]: (i18n) => i18n.str`Kinaray-a`,
  [LangCode.kr]: (i18n) => i18n.str`Kanuri`,
  [LangCode.krl]: (i18n) => i18n.str`Karelian`,
  [LangCode.kru]: (i18n) => i18n.str`Kurukh`,
  [LangCode.ksb]: (i18n) => i18n.str`Shambala`,
  [LangCode.ksf]: (i18n) => i18n.str`Bafia`,
  [LangCode.ksh]: (i18n) => i18n.str`Colognian`,
  [LangCode.ks]: (i18n) => i18n.str`Kashmiri`,
  [LangCode.ku]: (i18n) => i18n.str`Kurdish`,
  [LangCode.kum]: (i18n) => i18n.str`Kumyk`,
  [LangCode.kut]: (i18n) => i18n.str`Kutenai`,
  [LangCode.kv]: (i18n) => i18n.str`Komi`,
  [LangCode.kw]: (i18n) => i18n.str`Cornish`,
  [LangCode.ky]: (i18n) => i18n.str`Kyrgyz`,
  [LangCode.lad]: (i18n) => i18n.str`Ladino`,
  [LangCode.lag]: (i18n) => i18n.str`Langi`,
  [LangCode.lah]: (i18n) => i18n.str`Lahnda`,
  [LangCode.la]: (i18n) => i18n.str`Latin`,
  [LangCode.lam]: (i18n) => i18n.str`Lamba`,
  [LangCode.lb]: (i18n) => i18n.str`Luxembourgish`,
  [LangCode.lez]: (i18n) => i18n.str`Lezghian`,
  [LangCode.lfn]: (i18n) => i18n.str`Lingua Franca Nova`,
  [LangCode.lg]: (i18n) => i18n.str`Ganda`,
  [LangCode.lij]: (i18n) => i18n.str`Ligurian`,
  [LangCode.li]: (i18n) => i18n.str`Limburgish`,
  [LangCode.liv]: (i18n) => i18n.str`Livonian`,
  [LangCode.lkt]: (i18n) => i18n.str`Lakota`,
  [LangCode.lmo]: (i18n) => i18n.str`Lombard`,
  [LangCode.ln]: (i18n) => i18n.str`Lingala`,
  [LangCode.lo]: (i18n) => i18n.str`Lao`,
  [LangCode.lol]: (i18n) => i18n.str`Mongo`,
  [LangCode.loz]: (i18n) => i18n.str`Lozi`,
  [LangCode.ltg]: (i18n) => i18n.str`Latgalian`,
  [LangCode.lt]: (i18n) => i18n.str`Lithuanian`,
  [LangCode.lua]: (i18n) => i18n.str`Luba-Lulua`,
  [LangCode.lui]: (i18n) => i18n.str`Luiseno`,
  [LangCode.lu]: (i18n) => i18n.str`Luba-Katanga`,
  [LangCode.lun]: (i18n) => i18n.str`Lunda`,
  [LangCode.luo]: (i18n) => i18n.str`Luo`,
  [LangCode.lus]: (i18n) => i18n.str`Mizo`,
  [LangCode.luy]: (i18n) => i18n.str`Luyia`,
  [LangCode.lv]: (i18n) => i18n.str`Latvian`,
  [LangCode.lzh]: (i18n) => i18n.str`Literary Chinese`,
  [LangCode.lzz]: (i18n) => i18n.str`Laz`,
  [LangCode.mad]: (i18n) => i18n.str`Madurese`,
  [LangCode.maf]: (i18n) => i18n.str`Mafa`,
  [LangCode.mag]: (i18n) => i18n.str`Magahi`,
  [LangCode.mai]: (i18n) => i18n.str`Maithili`,
  [LangCode.mak]: (i18n) => i18n.str`Makasar`,
  [LangCode.man]: (i18n) => i18n.str`Mandingo`,
  [LangCode.mas]: (i18n) => i18n.str`Masai`,
  [LangCode.mde]: (i18n) => i18n.str`Maba`,
  [LangCode.mdf]: (i18n) => i18n.str`Moksha`,
  [LangCode.mdr]: (i18n) => i18n.str`Mandar`,
  [LangCode.men]: (i18n) => i18n.str`Mende`,
  [LangCode.mer]: (i18n) => i18n.str`Meru`,
  [LangCode.mfe]: (i18n) => i18n.str`Morisyen`,
  [LangCode.mga]: (i18n) => i18n.str`Middle Irish`,
  [LangCode.mgh]: (i18n) => i18n.str`Makhuwa-Meetto`,
  [LangCode.mg]: (i18n) => i18n.str`Malagasy`,
  [LangCode.mgo]: (i18n) => i18n.str`Metaʼ`,
  [LangCode.mh]: (i18n) => i18n.str`Marshallese`,
  [LangCode.mic]: (i18n) => i18n.str`Micmac`,
  [LangCode.mi]: (i18n) => i18n.str`Maori`,
  [LangCode.min]: (i18n) => i18n.str`Minangkabau`,
  [LangCode.mk]: (i18n) => i18n.str`Macedonian`,
  [LangCode.ml]: (i18n) => i18n.str`Malayalam`,
  [LangCode.mnc]: (i18n) => i18n.str`Manchu`,
  [LangCode.mni]: (i18n) => i18n.str`Manipuri`,
  [LangCode.mn]: (i18n) => i18n.str`Mongolian`,
  [LangCode.moh]: (i18n) => i18n.str`Mohawk`,
  [LangCode.mos]: (i18n) => i18n.str`Mossi`,
  [LangCode.mrj]: (i18n) => i18n.str`Western Mari`,
  [LangCode.mr]: (i18n) => i18n.str`Marathi`,
  [LangCode.ms]: (i18n) => i18n.str`Malay kasa`,
  [LangCode.mt]: (i18n) => i18n.str`Maltese`,
  [LangCode.mua]: (i18n) => i18n.str`Mundang`,
  [LangCode.mul]: (i18n) => i18n.str`Multiple Languages`,
  [LangCode.mus]: (i18n) => i18n.str`Creek`,
  [LangCode.mwl]: (i18n) => i18n.str`Mirandese`,
  [LangCode.mwr]: (i18n) => i18n.str`Marwari`,
  [LangCode.mwv]: (i18n) => i18n.str`Mentawai`,
  [LangCode.my]: (i18n) => i18n.str`Bɛɛmis kasa`,
  [LangCode.mye]: (i18n) => i18n.str`Myene`,
  [LangCode.myv]: (i18n) => i18n.str`Erzya`,
  [LangCode.mzn]: (i18n) => i18n.str`Mazanderani`,
  [LangCode.na]: (i18n) => i18n.str`Nauru`,
  [LangCode.nan]: (i18n) => i18n.str`Min Nan Chinese`,
  [LangCode.nap]: (i18n) => i18n.str`Neapolitan`,
  [LangCode.naq]: (i18n) => i18n.str`Nama`,
  [LangCode.nb]: (i18n) => i18n.str`Norwegian Bokmål`,
  [LangCode.nd]: (i18n) => i18n.str`North Ndebele`,
  [LangCode.nds]: (i18n) => i18n.str`Low German`,
  [LangCode.ne]: (i18n) => i18n.str`Nɛpal kasa`,
  [LangCode.new]: (i18n) => i18n.str`Newari`,
  [LangCode.ng]: (i18n) => i18n.str`Ndonga`,
  [LangCode.nia]: (i18n) => i18n.str`Nias`,
  [LangCode.niu]: (i18n) => i18n.str`Niuean`,
  [LangCode.njo]: (i18n) => i18n.str`Ao Naga`,
  [LangCode.nl_BE]: (i18n) => i18n.str`Flemish`,
  [LangCode.nl]: (i18n) => i18n.str`Dɛɛkye`,
  [LangCode.nmg]: (i18n) => i18n.str`Kwasio`,
  [LangCode.nnh]: (i18n) => i18n.str`Ngiemboon`,
  [LangCode.nn]: (i18n) => i18n.str`Norwegian Nynorsk`,
  [LangCode.nog]: (i18n) => i18n.str`Nogai`,
  [LangCode.non]: (i18n) => i18n.str`Old Norse`,
  [LangCode.no]: (i18n) => i18n.str`Norwegian`,
  [LangCode.nov]: (i18n) => i18n.str`Novial`,
  [LangCode.nqo]: (i18n) => i18n.str`NʼKo`,
  [LangCode.nr]: (i18n) => i18n.str`South Ndebele`,
  [LangCode.nso]: (i18n) => i18n.str`Northern Sotho`,
  [LangCode.nus]: (i18n) => i18n.str`Nuer`,
  [LangCode.nv]: (i18n) => i18n.str`Navajo`,
  [LangCode.nwc]: (i18n) => i18n.str`Classical Newari`,
  [LangCode.nym]: (i18n) => i18n.str`Nyamwezi`,
  [LangCode.nyn]: (i18n) => i18n.str`Nyankole`,
  [LangCode.ny]: (i18n) => i18n.str`Nyanja`,
  [LangCode.nyo]: (i18n) => i18n.str`Nyoro`,
  [LangCode.nzi]: (i18n) => i18n.str`Nzima`,
  [LangCode.oc]: (i18n) => i18n.str`Occitan`,
  [LangCode.oj]: (i18n) => i18n.str`Ojibwa`,
  [LangCode.om]: (i18n) => i18n.str`Oromo`,
  [LangCode.or]: (i18n) => i18n.str`Oriya`,
  [LangCode.osa]: (i18n) => i18n.str`Osage`,
  [LangCode.os]: (i18n) => i18n.str`Ossetic`,
  [LangCode.ota]: (i18n) => i18n.str`Ottoman Turkish`,
  [LangCode.pag]: (i18n) => i18n.str`Pangasinan`,
  [LangCode.pal]: (i18n) => i18n.str`Pahlavi`,
  [LangCode.pam]: (i18n) => i18n.str`Pampanga`,
  [LangCode.pap]: (i18n) => i18n.str`Papiamento`,
  [LangCode.pa]: (i18n) => i18n.str`Pungyabi kasa`,
  [LangCode.pau]: (i18n) => i18n.str`Palauan`,
  [LangCode.pcd]: (i18n) => i18n.str`Picard`,
  [LangCode.pdc]: (i18n) => i18n.str`Pennsylvania German`,
  [LangCode.pdt]: (i18n) => i18n.str`Plautdietsch`,
  [LangCode.peo]: (i18n) => i18n.str`Old Persian`,
  [LangCode.pfl]: (i18n) => i18n.str`Palatine German`,
  [LangCode.phn]: (i18n) => i18n.str`Phoenician`,
  [LangCode.pi]: (i18n) => i18n.str`Pali`,
  [LangCode.pl]: (i18n) => i18n.str`Pɔland kasa`,
  [LangCode.pms]: (i18n) => i18n.str`Piedmontese`,
  [LangCode.pnt]: (i18n) => i18n.str`Pontic`,
  [LangCode.pon]: (i18n) => i18n.str`Pohnpeian`,
  [LangCode.prg]: (i18n) => i18n.str`Prussian`,
  [LangCode.pro]: (i18n) => i18n.str`Old Provençal`,
  [LangCode.ps]: (i18n) => i18n.str`Pashto`,
  [LangCode.pt_BR]: (i18n) => i18n.str`Brazilian Portuguese`,
  [LangCode.pt]: (i18n) => i18n.str`Pɔɔtugal kasa`,
  [LangCode.pt_PT]: (i18n) => i18n.str`European Portuguese`,
  [LangCode.quc]: (i18n) => i18n.str`Kʼicheʼ`,
  [LangCode.qug]: (i18n) => i18n.str`Chimborazo Highland Quichua`,
  [LangCode.qu]: (i18n) => i18n.str`Quechua`,
  [LangCode.raj]: (i18n) => i18n.str`Rajasthani`,
  [LangCode.rap]: (i18n) => i18n.str`Rapanui`,
  [LangCode.rar]: (i18n) => i18n.str`Rarotongan`,
  [LangCode.rgn]: (i18n) => i18n.str`Romagnol`,
  [LangCode.rif]: (i18n) => i18n.str`Riffian`,
  [LangCode.rm]: (i18n) => i18n.str`Romansh`,
  [LangCode.rn]: (i18n) => i18n.str`Rundi`,
  [LangCode.rof]: (i18n) => i18n.str`Rombo`,
  [LangCode.ro_MD]: (i18n) => i18n.str`Moldavian`,
  [LangCode.rom]: (i18n) => i18n.str`Romany`,
  [LangCode.root]: (i18n) => i18n.str`Root`,
  [LangCode.ro]: (i18n) => i18n.str`Romenia kasa`,
  [LangCode.rtm]: (i18n) => i18n.str`Rotuman`,
  [LangCode.rue]: (i18n) => i18n.str`Rusyn`,
  [LangCode.rug]: (i18n) => i18n.str`Roviana`,
  [LangCode.rup]: (i18n) => i18n.str`Aromanian`,
  [LangCode.ru]: (i18n) => i18n.str`Rahyia kasa`,
  [LangCode.rwk]: (i18n) => i18n.str`Rwa`,
  [LangCode.rw]: (i18n) => i18n.str`Rewanda kasa`,
  [LangCode.sad]: (i18n) => i18n.str`Sandawe`,
  [LangCode.sah]: (i18n) => i18n.str`Sakha`,
  [LangCode.sam]: (i18n) => i18n.str`Samaritan Aramaic`,
  [LangCode.saq]: (i18n) => i18n.str`Samburu`,
  [LangCode.sa]: (i18n) => i18n.str`Sanskrit`,
  [LangCode.sas]: (i18n) => i18n.str`Sasak`,
  [LangCode.sat]: (i18n) => i18n.str`Santali`,
  [LangCode.saz]: (i18n) => i18n.str`Saurashtra`,
  [LangCode.sba]: (i18n) => i18n.str`Ngambay`,
  [LangCode.sbp]: (i18n) => i18n.str`Sangu`,
  [LangCode.scn]: (i18n) => i18n.str`Sicilian`,
  [LangCode.sco]: (i18n) => i18n.str`Scots`,
  [LangCode.sc]: (i18n) => i18n.str`Sardinian`,
  [LangCode.sdc]: (i18n) => i18n.str`Sassarese Sardinian`,
  [LangCode.sd]: (i18n) => i18n.str`Sindhi`,
  [LangCode.see]: (i18n) => i18n.str`Seneca`,
  [LangCode.seh]: (i18n) => i18n.str`Sena`,
  [LangCode.sei]: (i18n) => i18n.str`Seri`,
  [LangCode.sel]: (i18n) => i18n.str`Selkup`,
  [LangCode.se]: (i18n) => i18n.str`Northern Sami`,
  [LangCode.ses]: (i18n) => i18n.str`Koyraboro Senni`,
  [LangCode.sga]: (i18n) => i18n.str`Old Irish`,
  [LangCode.sg]: (i18n) => i18n.str`Sango`,
  [LangCode.sgs]: (i18n) => i18n.str`Samogitian`,
  [LangCode.shi]: (i18n) => i18n.str`Tachelhit`,
  [LangCode.shn]: (i18n) => i18n.str`Shan`,
  [LangCode.sh]: (i18n) => i18n.str`Serbo-Croatian`,
  [LangCode.shu]: (i18n) => i18n.str`Chadian Arabic`,
  [LangCode.sid]: (i18n) => i18n.str`Sidamo`,
  [LangCode.si]: (i18n) => i18n.str`Sinhala`,
  [LangCode.sk]: (i18n) => i18n.str`Slovak`,
  [LangCode.sli]: (i18n) => i18n.str`Lower Silesian`,
  [LangCode.sl]: (i18n) => i18n.str`Slovenian`,
  [LangCode.sly]: (i18n) => i18n.str`Selayar`,
  [LangCode.sma]: (i18n) => i18n.str`Southern Sami`,
  [LangCode.smj]: (i18n) => i18n.str`Lule Sami`,
  [LangCode.smn]: (i18n) => i18n.str`Inari Sami`,
  [LangCode.sm]: (i18n) => i18n.str`Samoan`,
  [LangCode.sms]: (i18n) => i18n.str`Skolt Sami`,
  [LangCode.snk]: (i18n) => i18n.str`Soninke`,
  [LangCode.sn]: (i18n) => i18n.str`Shona`,
  [LangCode.sog]: (i18n) => i18n.str`Sogdien`,
  [LangCode.so]: (i18n) => i18n.str`Somalia kasa`,
  [LangCode.sq]: (i18n) => i18n.str`Albanian`,
  [LangCode.srn]: (i18n) => i18n.str`Sranan Tongo`,
  [LangCode.srr]: (i18n) => i18n.str`Serer`,
  [LangCode.sr]: (i18n) => i18n.str`Serbian`,
  [LangCode.ss]: (i18n) => i18n.str`Swati`,
  [LangCode.ssy]: (i18n) => i18n.str`Saho`,
  [LangCode.stq]: (i18n) => i18n.str`Saterland Frisian`,
  [LangCode.st]: (i18n) => i18n.str`Southern Sotho`,
  [LangCode.suk]: (i18n) => i18n.str`Sukuma`,
  [LangCode.sus]: (i18n) => i18n.str`Susu`,
  [LangCode.su]: (i18n) => i18n.str`Sundanese`,
  [LangCode.sux]: (i18n) => i18n.str`Sumerian`,
  [LangCode.sv]: (i18n) => i18n.str`Sweden kasa`,
  [LangCode.swb]: (i18n) => i18n.str`Comorian`,
  [LangCode.swc]: (i18n) => i18n.str`Congo Swahili`,
  [LangCode.sw]: (i18n) => i18n.str`Swahili`,
  [LangCode.syc]: (i18n) => i18n.str`Classical Syriac`,
  [LangCode.syr]: (i18n) => i18n.str`Syriac`,
  [LangCode.szl]: (i18n) => i18n.str`Silesian`,
  [LangCode.ta]: (i18n) => i18n.str`Tamil kasa`,
  [LangCode.tcy]: (i18n) => i18n.str`Tulu`,
  [LangCode.tem]: (i18n) => i18n.str`Timne`,
  [LangCode.teo]: (i18n) => i18n.str`Teso`,
  [LangCode.ter]: (i18n) => i18n.str`Tereno`,
  [LangCode.te]: (i18n) => i18n.str`Telugu`,
  [LangCode.tet]: (i18n) => i18n.str`Tetum`,
  [LangCode.tg]: (i18n) => i18n.str`Tajik`,
  [LangCode.th]: (i18n) => i18n.str`Taeland kasa`,
  [LangCode.tig]: (i18n) => i18n.str`Tigre`,
  [LangCode.ti]: (i18n) => i18n.str`Tigrinya`,
  [LangCode.tiv]: (i18n) => i18n.str`Tiv`,
  [LangCode.tkl]: (i18n) => i18n.str`Tokelau`,
  [LangCode.tkr]: (i18n) => i18n.str`Tsakhur`,
  [LangCode.tk]: (i18n) => i18n.str`Turkmen`,
  [LangCode.tlh]: (i18n) => i18n.str`Klingon`,
  [LangCode.tli]: (i18n) => i18n.str`Tlingit`,
  [LangCode.tl]: (i18n) => i18n.str`Tagalog`,
  [LangCode.tly]: (i18n) => i18n.str`Talysh`,
  [LangCode.tmh]: (i18n) => i18n.str`Tamashek`,
  [LangCode.tn]: (i18n) => i18n.str`Tswana`,
  [LangCode.tog]: (i18n) => i18n.str`Nyasa Tonga`,
  [LangCode.to]: (i18n) => i18n.str`Tongan`,
  [LangCode.tpi]: (i18n) => i18n.str`Tok Pisin`,
  [LangCode.tr]: (i18n) => i18n.str`Tɛɛki kasa`,
  [LangCode.tru]: (i18n) => i18n.str`Turoyo`,
  [LangCode.trv]: (i18n) => i18n.str`Taroko`,
  [LangCode.tsd]: (i18n) => i18n.str`Tsakonian`,
  [LangCode.tsi]: (i18n) => i18n.str`Tsimshian`,
  [LangCode.ts]: (i18n) => i18n.str`Tsonga`,
  [LangCode.tt]: (i18n) => i18n.str`Tatar`,
  [LangCode.ttt]: (i18n) => i18n.str`Muslim Tat`,
  [LangCode.tum]: (i18n) => i18n.str`Tumbuka`,
  [LangCode.tvl]: (i18n) => i18n.str`Tuvalu`,
  [LangCode.twq]: (i18n) => i18n.str`Tasawaq`,
  [LangCode.tw]: (i18n) => i18n.str`Twi`,
  [LangCode.ty]: (i18n) => i18n.str`Tahitian`,
  [LangCode.tyv]: (i18n) => i18n.str`Tuvinian`,
  [LangCode.tzm]: (i18n) => i18n.str`Central Atlas Tamazight`,
  [LangCode.udm]: (i18n) => i18n.str`Udmurt`,
  [LangCode.uga]: (i18n) => i18n.str`Ugaritic`,
  [LangCode.ug]: (i18n) => i18n.str`Uyghur`,
  [LangCode.uk]: (i18n) => i18n.str`Ukren kasa`,
  [LangCode.umb]: (i18n) => i18n.str`Umbundu`,
  [LangCode.und]: (i18n) => i18n.str`Unknown Language`,
  [LangCode.ur]: (i18n) => i18n.str`Urdu kasa`,
  [LangCode.uz]: (i18n) => i18n.str`Uzbek`,
  [LangCode.vai]: (i18n) => i18n.str`Vai`,
  [LangCode.vec]: (i18n) => i18n.str`Venetian`,
  [LangCode.vep]: (i18n) => i18n.str`Veps`,
  [LangCode.ve]: (i18n) => i18n.str`Venda`,
  [LangCode.vi]: (i18n) => i18n.str`Viɛtnam kasa`,
  [LangCode.vls]: (i18n) => i18n.str`West Flemish`,
  [LangCode.vmf]: (i18n) => i18n.str`Main-Franconian`,
  [LangCode.vot]: (i18n) => i18n.str`Votic`,
  [LangCode.vo]: (i18n) => i18n.str`Volapük`,
  [LangCode.vro]: (i18n) => i18n.str`Võro`,
  [LangCode.vun]: (i18n) => i18n.str`Vunjo`,
  [LangCode.wae]: (i18n) => i18n.str`Walser`,
  [LangCode.wal]: (i18n) => i18n.str`Wolaytta`,
  [LangCode.war]: (i18n) => i18n.str`Waray`,
  [LangCode.was]: (i18n) => i18n.str`Washo`,
  [LangCode.wa]: (i18n) => i18n.str`Walloon`,
  [LangCode.wbp]: (i18n) => i18n.str`Warlpiri`,
  [LangCode.wo]: (i18n) => i18n.str`Wolof`,
  [LangCode.wuu]: (i18n) => i18n.str`Wu Chinese`,
  [LangCode.xal]: (i18n) => i18n.str`Kalmyk`,
  [LangCode.xh]: (i18n) => i18n.str`Xhosa`,
  [LangCode.xmf]: (i18n) => i18n.str`Mingrelian`,
  [LangCode.xog]: (i18n) => i18n.str`Soga`,
  [LangCode.yao]: (i18n) => i18n.str`Yao`,
  [LangCode.yap]: (i18n) => i18n.str`Yapese`,
  [LangCode.yav]: (i18n) => i18n.str`Yangben`,
  [LangCode.ybb]: (i18n) => i18n.str`Yemba`,
  [LangCode.yi]: (i18n) => i18n.str`Yiddish`,
  [LangCode.yo]: (i18n) => i18n.str`Yoruba`,
  [LangCode.yrl]: (i18n) => i18n.str`Nheengatu`,
  [LangCode.yue]: (i18n) => i18n.str`Cantonese`,
  [LangCode.zap]: (i18n) => i18n.str`Zapotec`,
  [LangCode.za]: (i18n) => i18n.str`Zhuang`,
  [LangCode.zbl]: (i18n) => i18n.str`Blissymbols`,
  [LangCode.zea]: (i18n) => i18n.str`Zeelandic`,
  [LangCode.zen]: (i18n) => i18n.str`Zenaga`,
  [LangCode.zgh]: (i18n) => i18n.str`Standard Moroccan Tamazight`,
  [LangCode.zh_Hans]: (i18n) => i18n.str`Simplified Chinese`,
  [LangCode.zh_Hant]: (i18n) => i18n.str`Traditional Chinese`,
  [LangCode.zh]: (i18n) => i18n.str`Kyaena kasa`,
  [LangCode.zun]: (i18n) => i18n.str`Zuni`,
  [LangCode.zu]: (i18n) => i18n.str`Zulu`,
  [LangCode.zxx]: (i18n) => i18n.str`No linguistic content`,
  [LangCode.zza]: (i18n) => i18n.str`Zaza`,
};
